/**
 * @file app.h
 * @author Bernd Giesecke (bernd@giesecke.tk)
 * @brief Defines, includes, global definitions
 * @version 0.1
 * @date 2023-05-04
 *
 * @copyright Copyright (c) 2023
 *
 */
#include <Arduino.h>
#include "wisblock_cayenne.h"


// Debug
// Debug output set to 0 to disable app debug output
extern bool serial_enabled;
#ifndef MY_DEBUG
#define MY_DEBUG 1
#endif

#if MY_DEBUG > 0
#if defined(_VARIANT_RAK3172_) || defined(_VARIANT_RAK3172_SIP_)
#define MYLOG(tag, ...)                      \
	if (serial_enabled)                      \
	{                                        \
		do                                   \
		{                                    \
			if (tag)                         \
				Serial.printf("[%s] ", tag); \
			Serial.printf(__VA_ARGS__);      \
			Serial.printf("\n");             \
		} while (0);                         \
		delay(100);                           \
	}
#else // RAK4630 || RAK11720
#define MYLOG(tag, ...)                      \
	if (serial_enabled)                      \
	{                                        \
		do                                   \
		{                                    \
			if (tag)                         \
				Serial.printf("[%s] ", tag); \
			Serial.printf(__VA_ARGS__);      \
			Serial.printf("\r\n");           \
			Serial6.printf(__VA_ARGS__);     \
			Serial6.printf("\r\n");          \
		} while (0);                         \
		delay(100);                           \
	}
#endif
#else
#define MYLOG(...)
#endif

	/** Custom flash parameters structure */
	struct custom_param_s
{
	uint8_t valid_flag = 0xAA;
	uint32_t send_interval = 0;
};

/** Custom flash parameters */
extern custom_param_s custom_parameters;

// Forward declarations
void sensor_handler(void *);
void send_packet(void);
bool init_status_at(void);
bool init_interval_at(void);
bool get_at_setting(void);
bool save_at_setting(void);

// LoRaWAN stuff
#include "wisblock_cayenne.h"
// Cayenne LPP Channel numbers per sensor value
#define LPP_CHANNEL_BATT 1	// Base Board
#define LPP_CHANNEL_HUMID 2 // RAK1901
#define LPP_CHANNEL_TEMP 3	// RAK1901
#define LPP_CHANNEL_PRESS 4 // RAK1902
#define LPP_CHANNEL_LIGHT 5 // RAK1903

extern WisCayenne g_solution_data;

// Sensor functions
bool init_rak1901(void);
void read_rak1901(void);
void startup_rak1901(void);
void shutdown_rak1901(void);
bool init_rak1902(void);
void read_rak1902(void);
void startup_rak1902(void);
void shutdown_rak1902(void);
bool init_rak1903(void);
void read_rak1903();
void startup_rak1903(void);
void shutdown_rak1903(void);

